/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.application.googleanalytics;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

import com.inet.application.googleanalytics.structure.GoogleAnalyticsConfigKeys;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.file.FileCombiner.RuntimeData;
import com.inet.lib.json.Json;

/**
 * AdHoc Configuration of the GA Plugin
 */
public class GoogleAnalyticsRuntimeData implements RuntimeData {

    /**
     * {@inheritDoc}
     */
    @Override
    public InputStream getDataStream() {

        StringBuilder string = new StringBuilder();

        Configuration current = ConfigurationManager.getInstance().getCurrent();
        if ( !current.get( GoogleAnalyticsConfigKeys.GA4_TRACKING_ID.getKey(), GoogleAnalyticsConfigKeys.GA4_TRACKING_ID.getDefault() ).isEmpty() ) {

            string.append( "GOGINFO = " );
            HashMap<String, Object> data = new HashMap<>();
            data.put( "gtagId", current.get( GoogleAnalyticsConfigKeys.GA4_TRACKING_ID.getKey(), GoogleAnalyticsConfigKeys.GA4_TRACKING_ID.getDefault() ) );
            data.put( "gtagCookie", current.get( GoogleAnalyticsConfigKeys.GA4_TRACKING_COOKIE.getKey(), GoogleAnalyticsConfigKeys.GA4_TRACKING_COOKIE.getDefault() ) );
            data.put( "gtagDomain", current.get( GoogleAnalyticsConfigKeys.GA4_TRACKING_COOKIE_DOMAIN.getKey(), GoogleAnalyticsConfigKeys.GA4_TRACKING_COOKIE_DOMAIN.getDefault() ) );
            data.put( "acceptedValue", "true" );
            data.put( "declinedValue", "false" );

            HashMap<String, Object> options = new HashMap<>();
            data.put( "options", options );

            string.append( new Json().toJson( data ) );
            string.append( ";" );
        }

        return new ByteArrayInputStream( string.toString().getBytes(StandardCharsets.UTF_8) );
    }

}
